package radiobutton;

import java.io.File;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.GroupBuilder;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Stage;

/* Primer preuzet sa: http://docs.oracle.com/javafx/2/ui_controls/RadioButtonSample.java.html
 * i prilagodjen tako da se koriste builder klase.
 */
public class RadioButtonTest extends Application {

	// ikona za prikaz slike
	// postavljena je slika koja se inicijalno prikazuje
    final ImageView icon = new ImageView(
    		new Image(
					getClass().getResourceAsStream(
    		"." + File.separator + "img" + File.separator + "Choose.png")
    		));
    
    public static void main(String[] args) {
        launch(args);
    }

    @Override
    public void start(Stage stage) {
    	Scene scene = SceneBuilder.create()
			.width(250) // sirina scene
			.height(150) // visina scene
			.root(kreirajScenu()) 
				// postavljanje komponente koja je koren grafa
				// kreirajScenu() je pomocni metod koji ce kreirati i
				// podesiti odgovarajucu komponentu, u ovom slucaju
				// objekat klase Group
			.build();
       
    	stage.setScene(scene);
    	stage.setTitle("RadioButton Test");
    	stage.sizeToScene();
    	stage.show();
    }
    
    public Parent kreirajScenu() {
    	Group group = GroupBuilder.create()
    			.style("-fx-background-color: lavender")
    			.children(
    					kreirajHBox()
    				)
    			.build();
    	return group;        
    }
    
    private Parent kreirajHBox() {
    	HBox hbox = HBoxBuilder.create()
    			.spacing(50)
    			.padding(new Insets(20, 10, 10, 20))
    			.children(
    					kreirajVBox(),
    					icon
    				)
    			.build();
    	
    	return hbox;
    }
    
    private Parent kreirajVBox() {

    	final ToggleGroup group = new ToggleGroup();

        RadioButton rb1 = new RadioButton("Home");
        rb1.setSelected(true); // inicijalno selektovano
        rb1.requestFocus(); // zahteva se fokus nad dugmetom
        rb1.setToggleGroup(group);
        rb1.setUserData("Kucica");
        
        RadioButton rb2 = new RadioButton("Calendar");
        rb2.setToggleGroup(group);
        rb2.setUserData("Calendar");

        RadioButton rb3 = new RadioButton("Contacts");
        rb3.setToggleGroup(group);
        // postavlja se svojstvo
        rb3.setUserData("Contacts");

        // posto su radio dugmad deo grupe, potrebno je dodati osluskivac
        // za svojstvo selectedToggle grupe koja sadrzi dugmad.
        group.selectedToggleProperty()
        	/* svojstvo koje oznacava selektovano dugme
        	 * i predstavljeno je klasom ReadOnlyObjectProperty<Toggle>
        	 * koja je natklasa za sva readonly svojstva koja su omotaci 
        	 * proizvoljnog objekta (u ovom slucaju Toggle dugmeta)
        	 * 
             * Slicno kao kod checkbox dugmadi, 
             * omogucen je dogadjaj:
             * - change event - oznacava da je vrednost svojstva promenjena
             * 
             * i odgovarajuci osluskivac dogadjaja (listener)
             * - ChangeListener
             * koji se moze registrovati za svojstvo
             */
        	.addListener(
        			/* registruje se osluskivac (listener) dogadjaja
        			 * radi se o objektu anonimne klase koja implementira
        			 * interfejs ChangeListener<Toggle>
        			 */
        			new ChangeListener<Toggle>(){
        				/* implementacija metoda changed() 
         				 * - prvi argument je vrednost cija se vrednost menja
         				 *   (ObservableValue)
         				 * - drugi argument je tekuca vrednost
         				 * - treci argument je nova vrednost
         				 */
        				public void changed(
        						ObservableValue<? extends Toggle> ov, 
            					Toggle old_toggle, 
            					Toggle new_toggle) {
        					/* ako postoji selektovano dugme... */
        					if (group.getSelectedToggle() != null) {                    	
        						String resource = "." + File.separator 
        								+ "img" + File.separator 
        								+ group.getSelectedToggle().getUserData().toString()  
        								+ ".png";
        					
        						// akcija koja treba da se izvrsi 
        						// u skladu sa izabranom opcijom 
        						final Image image = new Image(
        								getClass().getResourceAsStream(resource));
                    
        						icon.setImage(image);
        					}
        					                
        			}
        		});
        
        VBox vbox = VBoxBuilder.create()
        		.children(rb1, rb2, rb3)
        		.spacing(10)
        		.build();

        return vbox;
    }
}