package osobe;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Vector;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;

public class OsobeController implements Initializable {

	private Vector<Osoba> osobe = new Vector<Osoba>();

	@FXML
	private TextField tfImePrezime1;
	@FXML
	private TextField tfImePrezime2;
	@FXML
	private TextField tfGodiste1;
	@FXML
	private TextField tfGodiste2;
	@FXML
	private ToggleGroup toggleGRP;
	@FXML
	private RadioButton RBpoPrezimenuIImenu;
	@FXML
	private RadioButton RBpoGodinama;
	@FXML
	private Button btnUnesi;
	@FXML
	private Button btnPonisti;
	@FXML
	private Button btnSortiraj;
	@FXML
	private TextArea taIspis;

	@FXML
	private void handleButtonUnesi(ActionEvent event) {
		String imeIprezimeStr = tfImePrezime1.getText();
		int index = imeIprezimeStr.indexOf(' ');
		if (index == -1) {
			tfImePrezime1.setText("Neispravan unos!");
			return;
		}
		String ime = imeIprezimeStr.substring(0, index);
		String prezime = imeIprezimeStr.substring(index + 1).trim();

		try {
			int godiste = Integer.parseInt(tfGodiste1.getText());
			osobe.add(new Osoba(ime, prezime, godiste));
		} catch (NumberFormatException ex) {
			tfImePrezime1.setText("Neispravno godiste");
		}

	}

	@FXML
	private void handleButtonPonisti(ActionEvent event) {
		tfImePrezime1.setText("");
		tfGodiste1.setText("");

	}

	@FXML
	private void handleButtonSortiraj(ActionEvent event) {
		if(osobe.size()!=0)
		{
		if(RBpoPrezimenuIImenu.isSelected())
			Collections.sort(osobe);
		else
			Collections.sort(osobe, new Comparator<Osoba>(){
				public int compare(Osoba o1, Osoba o2){
					return o2.getGodiste()-o1.getGodiste();
				}
			});
		
		tfImePrezime2.setText(osobe.get(0).toString());
		tfGodiste2.setText(osobe.get(0).getGodiste()+"");
		
		taIspis.setText("");
		for(Osoba o: osobe)
			taIspis.appendText(o + " " + o.getGodiste()+"\n");
		}
		else taIspis.setText("Nema osoba za sortiranje!");
	}

	public void mouseEntered(MouseEvent e) {
		tfImePrezime2.setStyle("-fx-text-fill: red;-fx-font-size: 16;");
		
	}
	
	public void mouseExited(MouseEvent e) {
		tfImePrezime2.setStyle("-fx-text-fill: black;-fx-font-size: 12;");
	}
	
	public void mouseEntered2(MouseEvent e) {
		tfGodiste2.setStyle("-fx-text-fill: red;-fx-font-size: 16;");
	}
	
	public void mouseExited2(MouseEvent e) {
		tfGodiste2.setStyle("-fx-text-fill: black;-fx-font-size: 12;");
	}
	

	@Override
	public void initialize(URL url, ResourceBundle rb) {

	}
}
