package filechooser;

// Dokumentacija:
// http://docs.oracle.com/javafx/2/api/javafx/stage/FileChooser.html
	
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.Scanner;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.stage.FileChooser;
import javafx.stage.FileChooserBuilder;

public class FileChooserController implements Initializable {
    
    @FXML
    private Button dugme;
    
    @FXML
    private TextArea textArea;
    
    @FXML
    private void handleButtonAction(ActionEvent event) {
    	
    	/* FileChooser omogucuje navigaciju kroz file system, 
    	 * a potom izbor fajla ili direktorijuma ili pak zadavanje
    	 * njegovog imena. 
    	 * Objekat ove klase predstavlja samo prozor (dijalog) za izbor fajlova, 
    	 * a program je odgovoran
    	 * da preduzme nekakvu akciju nad izabranim fajlom, 
    	 * poput njegovog otvaranja ili cuvanja.
    	*/
    	
    	// Pomocna promenljiva za postavljanje pocetnog direktorijuma 
    	// FileChooser-a
    	File userDirectory;
    	
    	// Kreira se FileChooser
        FileChooser fileChooser = FileChooserBuilder.create()
        		.extensionFilters( 
        				// Moguce je postaviti filtere da bi se pruzila mogucnost 
        		        // otvaranja samo odredjenih tipova dokumenata
        				// - prvi argument je opis filtera - koji ce biti prikazan 
        				//   u listi kada se prozor za izbor dokumenta otvori
        				// - drugi argument je ekstenzija dokumenta koja se zadaje
        				//   kao string u formatu *.<ekstenzija>
        				new FileChooser.ExtensionFilter("TXT files (*.txt)", "*.txt"),
        				new FileChooser.ExtensionFilter("DOCX files (*.docx)", "*.docx")
        			)
        		.title("Izaberite dokument") // postavlja se naslov prozora u kome
        									 // se vrsi izbor dokumenta
        		
        		.initialDirectory(
        				(userDirectory = new File(
        						// Moguce je postaviti, po potrebi, da inicijalno bude
        						// otvoren pocetni direktorijum korisnika (home direktorijum),
        				        // a ako ne moze da mu se pristupi, 
        						// onda postavljamo neki drugi direktorijum - npr. C:
        						System.getProperty("user.home")
        							// vraca vrednost sistemskog svojstva sa datim imenom (kljucem)
        							// koji je String (ili null ako svojstvo sa datim imenom ne postoji)
        							
        						) // pravi se fajl na osnovu putanje koja se konvertuje u 
        						  // apsolutnu putanju
        				).canRead() // vraca true akko fajl zadat apsolutnom putanjom postoji
        							// i moze da se cita od strane aplikacije
        					? userDirectory : new File("c:/")
        			)
        		
        		.build();
        
                
        /* showOpenDialog() prikazuje dijaloski prozor za 
         * otvaranje fajla.
         * Povratna vrednost je izabrani fajl ili null
         * ako korisnik nista nije selektovao.
         * 
         * Argument metoda showOpenDialog() odredjuje roditeljsku 
         * komponentu za dijalog. 
         * Ova komponenta utice na poziciju dijaloga.
         * Dijalog se smesta direktno preko roditeljske komponente. 
         * Ako je roditeljska komponenta unutar prozora, 
         * onda dijalog zavisi od tog prozora. 
         * Dijalog nestaje kada se prozor minimizuje, a ponovo se 
         * pojavljuje nakon njegove maksimizacije.
         * 
         * Podrazumevano file chooser koji prethodno nije prikazivan 
         * prikazuje sadrzaj home direktorijuma korisnika. 
         */
        File file = fileChooser.showOpenDialog(
        		FileChooserTest.pomPrimaryStage);

        // Ako je fajl izabran na ispravan nacin 
        // prikazujemo njegov sadrzaj u okviru TextArea
        // pomocu metoda readFile() koji je definisan
        // u nastavku
        if(file != null){
        	StringBuffer text = readFile(file);
            textArea.setText(text.toString());
        }
        else
        	System.out.println("Pogresno izabran dokument!!!");
    	
    }
    
    @Override
    public void initialize(URL url, ResourceBundle rb) {
        
    } 
    
    // Metod kojim se ucitava sadrzaj fajla
    public StringBuffer readFile(File selectedFile){
    	
    	StringBuffer sb = new StringBuffer();
    	
    	final Charset KODIRANJE = StandardCharsets.UTF_8;
		Path putanja = Paths.get(selectedFile.getPath());
		
		/* citanje */
		
		try(Scanner sc = new Scanner(putanja, KODIRANJE.name())){
			// citanje sadrzaja metodima klase Scanner, ovde: linija po linija
			while (sc.hasNextLine()){
				String linija = sc.nextLine();
				sb.append(linija).append("\n");
			}
		}catch(IOException e){
			e.printStackTrace();
		}
		
		/* Drugi nacin */
		/*
    	StringBuffer sb = new StringBuffer();
    	String curLine = "";
    	
    	try {
    		FileReader fr = new FileReader(selectedFile);
    	    BufferedReader br = new BufferedReader(fr);
    	    while((curLine = br.readLine()) != null) {
    	    	sb.append(curLine).append("\n");
    	    }
    	               
    	    br.close();
    	} catch (Exception e){
    		e.getMessage();
    	}
    	*/
        return sb;
    }
}