package checkbox;

import java.io.File;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.GroupBuilder;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.control.CheckBox;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.StackPaneBuilder;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.stage.Stage;

/** Primer preuzet sa: http://docs.oracle.com/javafx/2/ui_controls/checkbox.htm
 *  i prilagodjen tako da se koriste builder klase.
 */
public class CheckBoxTest extends Application {

	// pravougaona povrsina za prikaz ikona sa slikama
    private Rectangle rect;

    // labele koje ce biti prikazane za checkbox dugmad
    final String[] names = new String[]{"Home", "Calendar", "Contacts"};
    
    // slike koje se prikazuju/uklanjaju selektovanjem/deselektovanjem
    // odgovarajuceg checkbox-a 
    final Image[] images = new Image[names.length];
    
    // odgovarajuci objekti klasa ImageView za prikaz slika
    final ImageView[] icons = new ImageView[names.length];
    
    // niz checkbox dugmadi
    final CheckBox[] cbs = new CheckBox[names.length];

    public static void main(String[] args) {
        launch(args);
    }

    @Override
    public void start(Stage stage) {
    	Scene scene = SceneBuilder.create()
			.width(400) // sirina scene
			.height(140) // visina scene
			.root(kreirajScenu()) 
				// postavljanje komponente koja je koren grafa
				// kreirajScenu() je pomocni metod koji ce kreirati i
				// podesiti odgovarajucu komponentu, u ovom slucaju
				// objekat klase Group
			
			.build();
    	
    	stage.setScene(scene);
    	stage.setTitle("CheckBox Test");
    	stage.sizeToScene();
    	stage.show();
    }
    
    // pravi se scena
    public Parent kreirajScenu() {
    	Group group = GroupBuilder.create()
    			// ne postoji predefinisana CSS klasa za Group
    			// pa se postavlja inline stil
    			.style("-fx-background-color: lavender")
    			.children(
    					kreirajHBox()
    				)
    			.stylesheets(
    					// omogucavanje CSS datoteke za primenu stilova
    			    	// za bilo koji kontejner moze se postaviti 
    			    	// styleshhet, ne samo za scenu
    					getClass().getResource(
    	        				"CheckBox.css"   // string sadrzi relativnu putanju .css dokumenta u 
    	        								 // odnosu na .class fajl
    	        								 // zadaje se samo ime fajla posto se 
    	        								 // nalazi u istom paketu kao i glavna klasa aplikacije
    	        				).toExternalForm() // generise String-reprezentaciju putanje
    				)
    			.build();
    	
    	/* drugi nacin za omogucavanje CSS datoteke sa stilovima */
    	/*
    	group.getStylesheets().add(
        		getClass().getResource("CheckBox.css" ).toExternalForm());
		*/
    	
    	return group;
    }
    
    // koreni cvor scene je HBox
    // njegova deca su VBox i Stack
    public Parent kreirajHBox() {
    	HBox root = HBoxBuilder.create()
    			.spacing(40)
    			.padding(new Insets(20, 10, 10, 20))
    			.children(
    					kreirajVBox(),
    					kreirajStack()
    				)
    			.build();
    	return root;
    }
    
    public Parent kreirajVBox() {
    	for (int i = 0; i < names.length; i++) {
    		// slike su predstavljene kasom Image
         	// Velicina slike moze da se promeni prilikom ucitavanja
         	final Image image = images[i] =
                 new Image(getClass()
                 		.getResourceAsStream( // pronalazi resurs na osnovu datog stringa 
                 							  // i vraca objekat klase InputStream
                 				"." + File.separator + "img" +  // File.separator je podrazumevani separator sistema
                 				File.separator + names[i] + ".png")
                 		);
         	// Za prikazivanje slika opisanih klasom Image koristi se klasa
         	// ImageView. Omogucava promenu velicine slike.
         	// ImageView zapravo predstavlja ikonu na kojoj ce biti
         	// prikazana slika kada se izabere checkbox dugme, 
         	// odnosno sa koje se uklanja slika kada se dugme deselektuje
         	final ImageView icon = icons[i] = new ImageView();

         	// CheckBox komponente se ne stavljaju u ToggleGroup i 
         	// moguce je da bude obelezeno vise opcija istovremeno 
            cbs[i] = new CheckBox(names[i]);
            // postavljanje stila za pojedinacno dugme
            /* cbs[i].setStyle(
            	    "-fx-border-color: lightblue; "
            	    + "-fx-font-size: 14;"
            	    + "-fx-border-insets: -5; "
            	    + "-fx-border-radius: 5;"
            	    + "-fx-border-style: dotted;"
            	    + "-fx-border-width: 2;"
            	);
            */
            cbs[i].selectedProperty() 
            		/* svojstvo oznacava da li je check box dugme selektovano
            		 * i predstavljeno je klasom BooleanProperty
            		 * koja obezbedjuje punu implementaciju interfejsa Property.
            		 * Predstavlja omotac za boolean vrednost.
            		 *
            		 * Klasa BooleanProperty implementira interfejs
            		 * ObservableBooleanValue<T>, a on dalje interfejs ObservableValue<T>.
            		 * ObservableBooleanValue je entitet koji obuhvata boolean vrednost 
            		 * i omogucava pracenje promena nad tom vrednoscu.
            		 * Slicno vazi i za ObservableValue u opstem slucaju. 
            		 *
            		 * Omogucena su dva tipa dogadjaja:
            		 * - change event - oznacava da je vrednost svojstva promenjena
            		 * - invalidation event - oznacava da tekuca vrednost svojstva vise nije validna
            		 * 
            		 * U skladu sa tim, dva tipa osluskivaca dogadjaja (listener)
            		 * mogu da se vezu za ObservableValue:
            		 * - InvalidationListener
            		 * - ChangeListener
            		 */			
             	.addListener(  
             			/* registruje se osluskivac (listener) dogadjaja
             			 * radi se o objektu anonimne klase koja implementira
             			 * interfejs ChangeListener<Boolean>
             			 */
             			new ChangeListener<Boolean>() { 
             				/* implementacija metoda changed() 
             				 * - prvi argument je vrednost cija se vrednost menja
             				 *   (ObservableValue)
             				 * - drugi argument je tekuca vrednost
             				 * - treci argument je nova vrednost
             				 */
             				public void changed(
             						ObservableValue<? extends Boolean> ov,
             						Boolean old_val, 
             						Boolean new_val) {
             							/* slika se pridruzuje ikoni, ako je nova vrednost
             							 * jednaka true.
             							 */
             							icon.setImage(new_val ? image : null);
             							
                 }
            });
    	}
    	
    	// checkbox dugmad se dodaju u VBox
        VBox vbox = VBoxBuilder.create()
        		 .spacing(15)
        		 .children(cbs)
        		 .build();
        
        return vbox;
    }
    
    public Parent kreirajStack() {
    	// Pravi se pravougaonik
    	rect = RectangleBuilder.create()
    			.width(230)
    			.height(85)
    			.arcWidth(10)
    			.arcHeight(10)
    			.fill(Color.BISQUE)
    			.build();
    	
    	// ikone su deo HBox-a
        HBox hbox = HBoxBuilder.create()
        		.padding(new Insets(10, 5, 10, 5))
        		.spacing(5)
        		.children(icons)
        		.build();
        
        StackPane stack = StackPaneBuilder.create()
        		.children(rect, hbox)
        		.build();
        
        StackPane.setAlignment(rect, Pos.TOP_CENTER);  
       
        return stack;
    }
      
 }