/**
 * program ilustruje citanje celih brojeva sa
 * standardnog ulaza (tastature)
 * i import-ovanje klasa koje ne pripadaju paketu java.lang
 * (u ovom slucaju klase Scanner iz paketa java.util)
 * 
 * Korisnik unese dva cela broja sa tastature, oni se saberu
 * i rezultat se ispise na standardni izlaz.
 */

package zbir;

import java.util.Scanner;

public class Zbir {

	public static void main(String[] args) {
		/*
		 * Kreiranje objekta sc klase Scanner koji ce
		 * sluziti za citanje sa standardnog ulaza
		 * (kreiranje objekta se uvek vrsi pozivom konstruktora klase,
		 * tj. metoda koji se zove isto kao i klasa, uz navodjenje kljucne
		 * reci new ispred.
		 * Promenljiva tipa klase je uvek referenca na objekat, a sam objekat smesta
		 * se negde drugde u memoriji)
		 */
		Scanner sc = new Scanner(System.in);
		
		System.out.println("Unesite ceo broj a:");
		int a = sc.nextInt(); // citanje broja tipa int sa ulaza metodom nextInt()
		
		System.out.println("Unesite ceo broj b:");
		int b = sc.nextInt();
		
		/* 
		 * zatvaranje resursa kada nam vise nije potreban.
		 * Za citanje sa tastature nije toliko neophodno,
		 * koliko npr. kada se cita iz fajla ili iz mreze
		 */
		sc.close();
		
		int zbir = a + b;
		
		/*
		 * za razliku od metoda println() koji nakon ispisa argumenta
		 * prelazi u novi red, metod print() samo ispisuje svoj argument
		 */
		System.out.print(a);
		if(b>=0)
			System.out.print("+");
		System.out.println(b+"="+zbir);
	}
}
